$(function () {
  // Load the navigation bar
  $("#navbar-de-placeholder").load("/de/nav.html", function () {
    var currentPath = window.location.pathname;

    $("#navbar a.nav-link").each(function () {
      var linkPath = $(this).attr("href");

      if (
        linkPath === currentPath ||
        (linkPath.endsWith("index.html") &&
          currentPath === linkPath.replace("index.html", ""))
      ) {
        $(this).addClass("active text-secondary");
      } else {
        $(this).removeClass("active");
      }
    });
  });
  
  $("#navbar-fa-placeholder").load("/fa/nav.html", function () {
    var currentPath = window.location.pathname;

    $("#navbar a.nav-link").each(function () {
      var linkPath = $(this).attr("href");

      if (
        linkPath === currentPath ||
        (linkPath.endsWith("index.html") &&
          currentPath === linkPath.replace("index.html", ""))
      ) {
        $(this).addClass("active text-secondary");
      } else {
        $(this).removeClass("active");
      }
    });
  });

  $("#navbar-en-placeholder").load("/en/nav.html", function () {
    var currentPath = window.location.pathname;

    $("#navbar a.nav-link").each(function () {
      var linkPath = $(this).attr("href");

      if (
        linkPath === currentPath ||
        (linkPath.endsWith("index.html") &&
          currentPath === linkPath.replace("index.html", ""))
      ) {
        $(this).addClass("active text-secondary");
      } else {
        $(this).removeClass("active");
      }
    });
  });

  // Load the footer
  $("#footer-placeholder").load("/footer.html");

  $("#carousel-placeholder").load("/discographyCarousel.html", function () {
    // وقتی که HTML کاروسل در DOM قرار گرفت، حالا اسکریپت initialize کننده کاروسل رو اجرا کن
    // این ensures می‌کنه که #albumTrack, .album-card, #nextBtn, #prevBtn وجود دارند
    $.getScript("/carouselInitializer.js")
      .done(function (script, textStatus) {
        console.log("carouselInitializer.js loaded and executed successfully.");
        // اگر تابع initialize کننده کاروسل شما داخل carouselInitializer.js
        // در یک تابع با نام خاصی مثل 'initMyCarousel' هست، اینجا باید اون رو صدا بزنید.
        // مثلا: initMyCarousel();
        // اما اگر کل کد در یک $(function() { ... }); قرار داره، خودش به صورت خودکار اجرا میشه.
      })
      .fail(function (jqxhr, settings, exception) {
        console.error("Failed to load carouselInitializer.js: ", exception);
      });
  });

  function initializeLightbox() {
    const lightbox = GLightbox({
      selector: ".glightbox",
      // You can add more options here, for example:
      // openEffect: 'zoom',
      // closeEffect: 'fade',
      // loop: true,
      // zoomable: true,
      // draggable: true,
    });
  }

  // بارگذاری عکس‌ها
  $("#photos-placeholder").load("/photos.html", function () {
    // بعد از بارگذاری عکس‌ها، GLightbox رو برای المنت‌های عکس فعال کن
    initializeLightbox();
  });

  // بارگذاری ویدیوها
  $("#videos-placeholder").load("/videos.html", function () {
    // بعد از بارگذاری ویدیوها، GLightbox رو برای المنت‌های ویدیو فعال کن
    initializeLightbox();
  });
});

// GLightbox initialization is now inside the callback function,
// so you can remove any separate initialization here.
