$(function () {
  // گرفتن ارجاع به المنت‌ها برای دسترسی راحت‌تر
  const $gallerySwitch = $("#gallerySwitch");
  const $videosPlaceholder = $("#videos-landing-placeholder");
  const $photosPlaceholder = $("#photos-landing-placeholder");
  const $photosLabel = $(".gallery .gap-3 p:first-child"); // برچسب "Photos"
  const $videosLabel = $(".gallery .gap-3 p:last-child"); // برچسب "Videos"

  // 1. بارگذاری همزمان محتوای عکس‌ها و ویدیوها در صفحه
  // محتوا بارگذاری می‌شود، اما نمایش داده شدن یا نشدن آن بستگی به وضعیت سوئیچ دارد.
  $videosPlaceholder.load("/landingVideos.html", function () {
    initializeLightbox(); // GLightbox را پس از بارگذاری ویدیوها مقداردهی اولیه کن
    // پس از بارگذاری، اطمینان حاصل شود که visibility اولیه بر اساس وضعیت سوئیچ صحیح است
    if ($gallerySwitch.is(":checked")) {
      $videosPlaceholder.show();
    } else {
      $videosPlaceholder.hide();
    }
  });

  $photosPlaceholder.load("/landingPhotos.html", function () {
    initializeLightbox(); // GLightbox را پس از بارگذاری عکس‌ها مقداردهی اولیه کن
    // پس از بارگذاری، اطمینان حاصل شود که visibility اولیه بر اساس وضعیت سوئیچ صحیح است
    if ($gallerySwitch.is(":checked")) {
      $photosPlaceholder.hide(); // اگر ویدیوها به طور پیش‌فرض انتخاب شده‌اند، عکس‌ها را مخفی کن
    } else {
      $photosPlaceholder.show(); // اگر عکس‌ها به طور پیش‌فرض انتخاب شده‌اند، عکس‌ها را نمایش بده
    }
  });

  // 2. تنظیم وضعیت اولیه نمایش بر اساس حالت پیش‌فرض سوئیچ (checked="true" یعنی ویدیوها نمایش داده شوند)
  if ($gallerySwitch.is(":checked")) {
    $photosPlaceholder.hide(); // عکس‌ها را مخفی کن
    $videosPlaceholder.show(); // ویدیوها را نمایش بده
    $videosLabel.removeClass("text-secondary").addClass("text-primary");
    $photosLabel.removeClass("text-primary").addClass("text-secondary");
  } else {
    // این حالت تنها در صورتی رخ می‌دهد که 'checked' را از input حذف کرده باشید
    $photosPlaceholder.show();
    $videosPlaceholder.hide();
    $videosLabel.removeClass("text-primary").addClass("text-secondary");
    $photosLabel.removeClass("text-secondary").addClass("text-primary");
  }

  // 3. افزودن شنونده رویداد (event listener) برای سوئیچ
  $gallerySwitch.on("change", function () {
    if ($(this).is(":checked")) {
      // سوئیچ فعال است (نمایش ویدیوها)
      $videosPlaceholder.show();
      $photosPlaceholder.hide();
      $videosLabel.removeClass("text-secondary").addClass("text-primary");
      $photosLabel.removeClass("text-primary").addClass("text-secondary");
    } else {
      // سوئیچ غیرفعال است (نمایش عکس‌ها)
      $videosPlaceholder.hide();
      $photosPlaceholder.show();
      $videosLabel.removeClass("text-primary").addClass("text-secondary");
      $photosLabel.removeClass("text-secondary").addClass("text-primary");
    }
    // نکته مهم: GLightbox را هر بار که visibility محتوا تغییر می‌کند، مجدداً مقداردهی اولیه کن.
    // این کار اطمینان می‌دهد که المنت‌های جدید قابل مشاهده، به درستی توسط GLightbox شناسایی می‌شوند.
    initializeLightbox();
  });
});

// این تابع (initializeLightbox) باید در یک فایل جداگانه و سراسری
// (مثلاً lightboxInitializer.js که قبلاً پیشنهاد دادم) تعریف شده باشد
// تا از هر جای پروژه قابل دسترسی باشد.
// مثال:
// function initializeLightbox() {
//   const lightbox = GLightbox({
//     selector: ".glightbox", // این سلکتور، GLightbox را روی تمام المنت‌های دارای کلاس glightbox فعال می‌کند
//     // گزینه‌های دیگر GLightbox می‌توانند اینجا اضافه شوند
//     // openEffect: 'zoom',
//     // closeEffect: 'fade',
//     // loop: true,
//     // zoomable: true,
//     // draggable: true,
//   });
// }
// $(document).ready(function() { initializeLightbox(); }); // این فراخوانی اولیه هم ضروری است
