// carouselInitializer.js
$(function () {
  const $track = $("#albumTrack");
  const $cards = $track.find(".album-card");
  const isRTL = $("html").attr("dir") === "rtl";
  let position = 0;

  // بررسی می‌کنیم که المنت‌ها واقعاً وجود دارند یا نه
  if ($track.length === 0 || $cards.length === 0) {
    console.warn(
      "Carousel elements not found. Make sure #albumTrack and .album-card are loaded."
    );
    return; // اگه المنت‌ها پیدا نشدن، از اجرا خارج شو
  }

  function getVisibleCount() {
    const width = $(window).width();
    if (width >= 1200) return 3;
    if (width >= 768) return 2;
    return 1;
  }

  function updateCarousel() {
    const visibleCount = getVisibleCount();
    // outerWidth(true) برای محاسبه عرض المنت به همراه margin
    const cardWidth = $cards.first().outerWidth(true);

    // محاسبه حداکثر موقعیت قابل اسکرول
    const maxPosition = $cards.length - visibleCount;
    if (maxPosition < 0) {
      // اگه تعداد کارت‌ها کمتر از تعداد قابل نمایش باشه، اسکرول لازم نیست
      position = 0;
      $track.css("transform", `translateX(0px)`);
      $("#nextBtn, #prevBtn").hide(); // دکمه‌ها رو مخفی کن
      return;
    }

    // مطمئن شدن از اینکه position در محدوده مجاز قرار داره
    if (position > maxPosition) position = maxPosition;
    if (position < 0) position = 0;

    const offset = position * cardWidth;
    // مقدار translate بستگی به جهت صفحه (RTL/LTR) داره
    const translateValue = isRTL ? offset : -offset;

    $track.css("transform", `translateX(${translateValue}px)`);

    // دکمه‌ها رو اگه مخفی شده بودن، نمایش بده
    $("#nextBtn, #prevBtn").show();
  }

  // ایونت برای دکمه بعدی
  $("#nextBtn").click(function () {
    const visibleCount = getVisibleCount();
    const maxPosition = $cards.length - visibleCount;

    position = position < maxPosition ? position + 1 : 0; // حرکت به کارت بعدی یا برگشت به اول
    updateCarousel();
  });

  // ایونت برای دکمه قبلی
  $("#prevBtn").click(function () {
    const visibleCount = getVisibleCount();
    const maxPosition = $cards.length - visibleCount;

    position = position > 0 ? position - 1 : maxPosition; // حرکت به کارت قبلی یا برگشت به آخر
    updateCarousel();
  });

  // به‌روزرسانی کاروسل هنگام تغییر سایز پنجره
  $(window).on("resize", updateCarousel);

  // فراخوانی اولیه برای تنظیم کاروسل هنگام بارگذاری
  updateCarousel();

  // یک تاخیر کوتاه برای اطمینان از بارگذاری کامل تصاویر (اگه تصاویر روی عرض کارت‌ها تاثیر دارن)
  setTimeout(updateCarousel, 500); // می‌تونید زمان تاخیر رو تنظیم کنید
});
