$(document).ready(function () {
  // یک تابع برای ایجاد افکت تایپ که المنت و تنظیمات را دریافت می‌کند
  function setupTypingEffect($element) {
    // فقط texts را از data attribute می‌خوانیم
    var texts = $element.data("words");

    // سرعت‌ها و تأخیرها را به صورت ثابت در کد جاوا اسکریپت تعریف می‌کنیم
    // این‌ها دیگر از HTML خوانده نمی‌شوند و برای همه نمونه‌ها یکسان خواهند بود
    var typingSpeed = 50;
    var erasingSpeed = 20;
    var delayBetweenTexts = 1000;
    var initialDelay = 500; // تأخیر قبل از شروع تایپ متن بعدی

    var index = 0;
    var charIndex = 0;

    function type() {
      if (charIndex < texts[index].length) {
        $element.append(texts[index].charAt(charIndex));
        charIndex++;
        setTimeout(type, typingSpeed);
      } else {
        setTimeout(erase, delayBetweenTexts);
      }
    }

    function erase() {
      if (charIndex > 0) {
        $element.text(texts[index].substring(0, charIndex - 1));
        charIndex--;
        setTimeout(erase, erasingSpeed);
      } else {
        index = (index + 1) % texts.length;
        setTimeout(type, initialDelay);
      }
    }

    type(); // شروع تایپ
  }

  // حالا تابع را برای هر المنتی که می‌خواهیم افکت تایپ داشته باشد، صدا می‌زنیم
  setupTypingEffect($("#typed-text"));
  setupTypingEffect($("#another-typed-text")); // برای نمونه دوم
});
